<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Define the necessary constants for later use.
define( 'NAGATHEME_RANK_MATH_PRO_FILE', __FILE__ );

define( 'NAGATHEME_RANK_MATH_PRO_PATH', plugin_dir_path( __FILE__ ) );

define( 'NAGATHEME_RANK_MATH_PRO_URL', plugin_dir_url( __FILE__ ) );

require_once NAGATHEME_RANK_MATH_PRO_PATH . 'includes/requirements.php';

require_once NAGATHEME_RANK_MATH_PRO_PATH . 'vendor/autoload.php';

use NagaTheme\RankMathPro\Includes\Requirements;

if ( Requirements::run_compatibility_check() ) {

	// Load NagaTheme License, RTL and Persian Files.
	require_once( NAGATHEME_RANK_MATH_PRO_PATH . 'naga-rank-math-ic.php' );
} else {

	// Requirements are not met.
	// NagaTheme functionalities are required in case for Rank Math Pro to work properly.
	add_action(
		'admin_menu',
		function () {
			global $submenu;
			$slug = 'rank-math';
			remove_menu_page( $slug );
			if ( isset( $submenu[ $slug ] ) ) {
				unset( $submenu[ $slug ] );
			}
		},
		999999
	);
}